// URLs: página de ventas (send.masszaps.com = landing de código) y app
const SALES_PAGE_URL = 'https://send.masszaps.com';
const APP_URL = 'https://app.masszaps.com';
const BULK_MESSAGES_PATH = '/bulk-messages';
const SALES_PLAN_ANCHOR = '#planes';
const SALES_FAQ_ANCHOR = '#faq';
const ASSISTANCE_URL = 'https://send.masszaps.com/#asistencia';
const WHATSAPP_NUMBER = '573165374908';
const WHATSAPP_MSG = 'Hola, vengo de la extensión MassZaps';

const TIPS = [
  'Personaliza tus mensajes con el nombre del contacto para mayor apertura.',
  'Envía en horarios laborales (9h–18h) para mejorar la tasa de respuesta.',
  'Evita muchos mensajes seguidos; WhatsApp puede restringir la cuenta.',
  'Conecta tu instancia Evolution API en la app para empezar a enviar.',
  'Usa esta extensión para abrir la app rápido desde cualquier pestaña.',
  'Mensajes cortos y claros suelen tener mejor respuesta que textos largos.',
  'Respeta la privacidad: solo envía a quien haya dado su consentimiento.',
];

const tipText = document.getElementById('tip-text');
const btnBulkMessages = document.getElementById('btn-bulk-messages');
const btnPlanMensual = document.getElementById('btn-plan-mensual');
const btnPlanAnual = document.getElementById('btn-plan-anual');
const btnOpenApp = document.getElementById('btn-open-app');
const linkMoreInfo = document.getElementById('link-more-info');
const linkFirstTime = document.getElementById('link-first-time');
const linkFaq = document.getElementById('link-faq');
const linkPrivacy = document.getElementById('link-privacy');
const linkWhatsapp = document.getElementById('link-whatsapp');

function openInNewTab(url) {
  chrome.tabs.create({ url });
}

function init() {
  const plansUrl = SALES_PAGE_URL + SALES_PLAN_ANCHOR;
  const bulkMessagesUrl = APP_URL + BULK_MESSAGES_PATH;

  if (tipText && TIPS.length) {
    tipText.textContent = TIPS[Math.floor(Math.random() * TIPS.length)];
  }

  btnBulkMessages.href = bulkMessagesUrl;
  btnPlanMensual.href = plansUrl;
  btnPlanAnual.href = plansUrl;
  btnOpenApp.href = APP_URL + '/login';
  linkMoreInfo.href = SALES_PAGE_URL;
  linkFirstTime.href = SALES_PAGE_URL;
  linkFaq.href = ASSISTANCE_URL;
  linkWhatsapp.href = `https://wa.me/${WHATSAPP_NUMBER}?text=${encodeURIComponent(WHATSAPP_MSG)}`;

  btnBulkMessages.addEventListener('click', (e) => {
    e.preventDefault();
    openInNewTab(bulkMessagesUrl);
  });

  btnPlanMensual.addEventListener('click', (e) => {
    e.preventDefault();
    openInNewTab(plansUrl);
  });

  btnPlanAnual.addEventListener('click', (e) => {
    e.preventDefault();
    openInNewTab(plansUrl);
  });

  btnOpenApp.addEventListener('click', (e) => {
    e.preventDefault();
    openInNewTab(APP_URL + '/login');
  });

  linkMoreInfo.addEventListener('click', (e) => {
    e.preventDefault();
    openInNewTab(SALES_PAGE_URL);
  });

  linkFirstTime.addEventListener('click', (e) => {
    e.preventDefault();
    openInNewTab(SALES_PAGE_URL);
  });

  linkFaq.addEventListener('click', (e) => {
    e.preventDefault();
    openInNewTab(ASSISTANCE_URL);
  });

  linkPrivacy.addEventListener('click', (e) => {
    e.preventDefault();
    openInNewTab(PRIVACY_POLICY_URL);
  });

  linkWhatsapp.addEventListener('click', (e) => {
    e.preventDefault();
    openInNewTab(linkWhatsapp.href);
  });
}

init();
